/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.superplan;

import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.superplan.ProductionTreeVisitorAdapter;
import cz.insophy.inplan.superplan.Superplan;
import java.util.HashSet;
import java.util.Set;

public class PtnPossibleWorkplaceCollector
extends ProductionTreeVisitorAdapter {
    private final HashSet<Workplace> workplaceSet;
    private final ProductionTreeNode root;
    private final ShopConfiguration configuration;

    public PtnPossibleWorkplaceCollector(ProductionTreeNode root) {
        this.root = root;
        Superplan superplan = root.getSuperplan();
        if (superplan == null) {
            throw new IllegalStateException("PtnPossibleWorkplaceCollector has meaning only when it is used with PTN that is under a superplan.");
        }
        this.configuration = superplan.getShopConf();
        this.workplaceSet = new HashSet();
    }

    private void visit(Action action) {
        for (Action la : action.getLocalAlts()) {
            this.workplaceSet.addAll(this.configuration.getWorkplaces(la.getCapabilityReq()));
        }
    }

    @Override
    public void visit(GeneralizedActionRequest gar) {
        this.visit(gar.getAction());
    }

    @Override
    public void visit(GeneralizedOrderRequest gor) {
        if (!gor.hasSelectedActiongram()) {
            for (Actiongram ag : gor.getProduct().getActiongrams()) {
                for (Action a : ag.getActions()) {
                    this.visit(a);
                }
            }
        }
    }

    public Set<Workplace> collectWorkplaces() {
        this.root.accept(this, false);
        return this.workplaceSet;
    }

    public static Set<Workplace> collectFrom(ProductionTreeNode ptn) {
        return new PtnPossibleWorkplaceCollector(ptn).collectWorkplaces();
    }
}

